/* 
 * npeserv.c
 *
 * Моделює роботу сервера, який отримує клієнтські запити через
 * іменований канал. Обслуговування запитів зводиться до їх виведення
 * в стандартний потік виведення результатів.  
 * Ілюструє порядок застосування іменованих каналів.
 *
 */

#include "npe.h"

#define PERM    0666
#define ERRLOG "npeserv.err"    /* Журнал повідомлень про помилки */


int main()
{
        char buf[BUFSIZE]; 	
        int pdr;

        /* Зв'язує стандартний потік виведення повідомлень про помилки
           з файлом ERRLOG (потрібно, оскільки може працювати в фоновому
           режимі). */
        if (freopen(ERRLOG, "w", stderr) == NULL) {
                perror("freopen(ERRLOG, ...)");
                exit(EXIT_FAILURE);
        }    

        /* Створює іменований канал (якщо він не існує). */
        if ((mkfifo(PIPE_TO_SERVER, PERM) != 0) && (errno != EEXIST)) {
                perror("mkfifo(PIPE_TO_SERVER, ...)");
                exit(EXIT_FAILURE);
        }

        /* Відкриває іменований канал на читання. */
        pdr = open(PIPE_TO_SERVER, O_RDONLY);
        if (pdr < 0) {
                perror("open(PIPE_TO_SERVER, ...)");
                if (unlink(PIPE_TO_SERVER) != 0)
                        perror("unlink(PIPE_TO_SERVER)");
                exit(EXIT_FAILURE);
        }
        /* Видаляє з файлової системи посилання на іменований канал. */
        if (unlink(PIPE_TO_SERVER) != 0)
                perror("unlink(PIPE_TO_SERVER)");

        while (1) {
                int count;
                
                /* Отримує від клієнта повідомлення. */
                count = read(pdr, buf, BUFSIZE);
                if (count < 0) {
                        perror("read()");
                        exit(EXIT_FAILURE);
                }
                if (count == 0) 
                        /* Клієнт закрив канал. */
                        break;
                /* Виводить отримане повідомлення. */
                printf("Received: %s\n", buf);
        }

        exit(EXIT_SUCCESS);
}
